using System;

namespace gov.va.med.vbecs.BOL
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary></summary>

		#endregion


	public class NoRecordsFoundException : BusinessObjectException
	{
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1227"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Valid NoRecordsFoundException object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="385"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Empty NoRecordsFoundException constructor
		/// </summary>
		public NoRecordsFoundException() : base()
		{
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1228"> 
		///		<ExpectedInput>Message input string</ExpectedInput>
		///		<ExpectedOutput>Valid NoRecordsFoundException class with input string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2153"> 
		///		<ExpectedInput>Null value</ExpectedInput>
		///		<ExpectedOutput>Generic exception error message</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// NoRecordsFoundException constructor
		/// </summary>
		public NoRecordsFoundException(string message) : base(message)
		{
		} 

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1229"> 
		///		<ExpectedInput>Message input string and exception</ExpectedInput>
		///		<ExpectedOutput>Valid LockException class</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2154"> 
		///		<ExpectedInput>Null message and null exception</ExpectedInput>
		///		<ExpectedOutput>Generic exception error message and null value for inner exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// NoRecordsFoundException constructor
		/// </summary>
		public NoRecordsFoundException(string message, Exception inner) : base(message, inner)
		{
		}

	}
}

